Attribute VB_Name = "stdpipes"
Option Explicit

Public Const GENERIC_WRITE = &H40000000
Public Const GENERIC_READ = &H80000000
Const FILE_ATTRIBUTE_NORMAL = &H80
Const CREATE_ALWAYS = 2
Const OPEN_ALWAYS = 4
Const INVALID_HANDLE_VALUE = -1

Public Const STD_INPUT_HANDLE = -10&
Public Const STD_OUTPUT_HANDLE = -11&

Public Declare Function Sleep Lib "kernel32" _
(ByVal dwMilliseconds As Long) As Long

Public Declare Function stdin Lib "kernel32" Alias "GetStdHandle" _
(Optional ByVal Handletype As Long = STD_INPUT_HANDLE) As Long

Public Declare Function stdout Lib "kernel32" Alias "GetStdHandle" _
(Optional ByVal Handletype As Long = STD_OUTPUT_HANDLE) As Long

Public Declare Function ReadFile Lib "kernel32" _
(ByVal hFile As Long, ByVal lpBuffer As Any, ByVal nNumberOfBytesToRead As Long, _
lpNumberOfBytesRead As Long, Optional ByVal lpOverlapped As Long = 0&) As Long

Public Declare Function WriteFile Lib "kernel32" _
(ByVal hFile As Long, ByVal lpBuffer As Any, ByVal nNumberOfBytesToWrite As Long, _
lpNumberOfBytesWritten As Long, Optional ByVal lpOverlapped As Long = 0&) As Long

Private Declare Function CloseHandle Lib "kernel32" ( _
        ByVal hObject As Long) As Long

Private Declare Function CreateFile Lib "kernel32" _
        Alias "CreateFileA" (ByVal lpFileName As String, _
        ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, _
        ByVal lpSecurityAttributes As Long, _
        ByVal dwCreationDisposition As Long, _
        ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) _
        As Long

Declare Function FlushFileBuffers Lib "kernel32" ( _
        ByVal hFile As Long) As Long

Function cpstdin2file(filename As String)
     
    Dim sReadBuffer As String
    Dim sWriteBuffer As String
    Dim lBytesRead As Long
    Dim lBytesWritten As Long
    Dim hStdIn As Long
    Dim hStdOut As Long
    Dim iPos As Integer
    Dim fHandle As Long
    Dim fSuccess As Long
    
    Const maxbuffer = 65536
    
    sReadBuffer = String$(maxbuffer, 0)
    ' Get STDIN handle
    hStdIn = stdin()
        
    fHandle = CreateFile(filename, GENERIC_WRITE Or GENERIC_READ, _
                              0, 0, CREATE_ALWAYS, FILE_ATTRIBUTE_NORMAL, 0)
    If fHandle <> INVALID_HANDLE_VALUE Then
        ' Read client's input
        Do
            ReadFile hStdIn, sReadBuffer, Len(sReadBuffer), lBytesRead
            'MsgBox sReadBuffer
            fSuccess = WriteFile(fHandle, sReadBuffer, _
                        lBytesRead, lBytesWritten, 0)
        Loop While lBytesRead > 0
    Else
        MsgBox "error creating file over api functions!"
        MsgBox filename
    End If
    
    'Flush the file buffers to force writing of the data.
    fSuccess = FlushFileBuffers(fHandle)
    'Close the file.
    fSuccess = CloseHandle(fHandle)

End Function
