Attribute VB_Name = "mainmod"
Option Explicit

Const reg_key = "SOFTWARE\GNU\w2hfax"
'Const reg_hive = HKEY_LOCAL_MACHINE
Const reg_hive = HKEY_CURRENT_USER
Const rcvfmtcmd = "RCVFMT ""%t|%f|%s|%p|%o"""
Const askAboutComRegistering As Boolean = True
Const pythonutils_hylafaxutil As String = "pythonutils.hylafaxutil"

Public faxsession
Public faxserver
Public faxuser
Public faxpw
Public Psviewer
Public tifviewer
Public debuglevel
Public logfile
Public Autologon
Public emailaddress
Public tmpfilelist As New Collection

Dim loginrc

Public Sub Main()
    Dim spoolfile As String
    Dim prompt As String
    Dim objErrorText As String
    
    Call loadsettings
    
    Set faxsession = CreateObjectSafe(pythonutils_hylafaxutil, , objErrorText)
    If (faxsession Is Nothing) Then
        'MsgBox "Failed using com-server """ & pythonutils_hylafaxutil & """."
    
        prompt = _
            "An error occoured, " & "'CreateObject(""" & pythonutils_hylafaxutil & """)' failed. " & vbCrLf & _
            "The native win32-error was: """ & objErrorText & """." & vbCrLf & vbCrLf & _
            "Please read ""install.txt"" and ""installsetup.txt"" for installing the python-com-object (hylafax-wrapper)." & vbCrLf & vbCrLf & _
            "Shortcut:" & vbCrLf & _
            "   - call ""hfaxcom.py"" for registering the com-component and ..." & vbCrLf & _
            "   - ""hfaxcom.py --unregister"" for unregistering it. (like ""regsvr32 /u"")" & vbCrLf & vbCrLf & _
            "Try to register this component?"
        
        If (registerComObject(pythonutils_hylafaxutil, App.Path & "\hfaxcom.py", askAboutComRegistering, prompt)) Then
            Set faxsession = CreateObjectSafe(pythonutils_hylafaxutil, 5)
            If (faxsession Is Nothing) Then
                MsgBox "Failed registering com-server """ & pythonutils_hylafaxutil & """."
                End
            End If
        Else
            End
        End If
    End If
    
    Call faxsession.setdebuginfo(CInt(debuglevel), (logfile))
    
    loginrc = 0
    Do
        ' Show login dialog if the last login is not successfull or autologon is not enabled and we are not a print dialog
        ' if we are printing then always try to logon first
        If loginrc <> 0 Or (Not Autologon = "1" And Command$() <> "printdialog") Then
            frmLogin.Show vbModal
            If frmLogin.LoginSucceeded Then
                ' store the login information
                SetKeyValue reg_hive, reg_key, "faxserver", faxserver, REG_SZ
                SetKeyValue reg_hive, reg_key, "user", faxuser, REG_SZ
                SetKeyValue reg_hive, reg_key, "password", faxpw, REG_SZ
                SetKeyValue reg_hive, reg_key, "autologon", Autologon, REG_SZ
            Else
                ' if the user cancel the login, we are exiting the app
                End
            End If
        End If
        
        loginrc = faxsession.Connect(faxserver, faxuser, faxpw)
        Select Case loginrc
        Case 0:
        Case 1:
            MsgBox "Cannt login, wrong username or password."
        Case 2:
            MsgBox "Cannt connect, socket error."
        Case Else:
            MsgBox "Login failure: " & CStr(loginrc)
        End Select
        
    Loop While loginrc <> 0
  
    Call faxsession.docmd(rcvfmtcmd)
    Call faxsession.docmd("JOBFMT ""%j|%i|%a|%o|%e|%P|%D|%z|%s""")
    Call faxsession.docmd("TYPE I")
    Call faxsession.docmd("MODE S")
    
    If Command$() = "printdialog" Then
        spoolfile = tmpfile(".tmp")
        Call cpstdin2file(spoolfile)
        
        Sendfax.faxdocuments.AddItem (spoolfile)
        Sendfax.Show vbModal
        faxsession.Close
        Set faxsession = Nothing
        Call rmtmpfiles
        
        End
    Else
        MainForm.addserver
        'We must change the code to establish always a new connection
        'or change the library to do a autologin if the connection timed out :(
        MainForm.Timer1.Enabled = True
        MainForm.Show
    End If
End Sub

Public Function login(server As String, user As String, pw As String)
Dim rc
    rc = faxsession.Connect(faxserver, faxuser)
    If rc = 0 Then
        
    End If
    login = rc
End Function

Sub loadsettings()
    ' Defaults, if nothing is in the registry
    'psviewer = "notepad.exe"
    Psviewer = "C:\Ghostgum\gsview\gsview32.exe"
    tifviewer = "C:\Program Files\Windows NT\Accessories\ImageVue\wangimg.exe"
    faxserver = "192.168.1.1"
    faxuser = "root"
    faxpw = ""
    logfile = "c:\w2hfax.log"
    debuglevel = 0
    Autologon = 0
    
    CreateNewKey reg_hive, reg_key
    CreateNewKey reg_hive, reg_key & "\Addressbooks"
    
    If QueryValue(reg_hive, reg_key, "faxserver") <> "" Then faxserver = QueryValue(reg_hive, reg_key, "faxserver")
    If QueryValue(reg_hive, reg_key, "user") <> "" Then faxuser = QueryValue(reg_hive, reg_key, "user")
    If QueryValue(reg_hive, reg_key, "password") <> "" Then faxpw = QueryValue(reg_hive, reg_key, "password")
    If QueryValue(reg_hive, reg_key, "psviewer") <> "" Then Psviewer = QueryValue(reg_hive, reg_key, "psviewer")
    If QueryValue(reg_hive, reg_key, "tifviewer") <> "" Then tifviewer = QueryValue(reg_hive, reg_key, "tifviewer")
    If QueryValue(reg_hive, reg_key, "debuglevel") <> "" Then debuglevel = QueryValue(reg_hive, reg_key, "debuglevel")
    If QueryValue(reg_hive, reg_key, "logfile") <> "" Then logfile = QueryValue(reg_hive, reg_key, "logfile")
    If QueryValue(reg_hive, reg_key, "autologon") <> "" Then Autologon = QueryValue(reg_hive, reg_key, "autologon")
    If QueryValue(reg_hive, reg_key, "emailaddress") <> "" Then emailaddress = QueryValue(reg_hive, reg_key, "emailaddress")
     
    Call loadadrbook_info
End Sub
Public Sub loadadrbook_info()
Dim x As Collection
Dim book
    Set x = EnumKey(reg_hive, reg_key & "\Addressbooks")
    adrbooks_count = 0
    For Each book In x
        adrbooks(adrbooks_count).name = book
        adrbooks(adrbooks_count).atype = QueryValue(reg_hive, reg_key & "\Addressbooks\" & book, "atype")
        adrbooks(adrbooks_count).filename = QueryValue(reg_hive, reg_key & "\Addressbooks\" & book, "filename")
        adrbooks_count = adrbooks_count + 1
    Next
End Sub

Public Sub savesettings()
    SetKeyValue reg_hive, reg_key, "faxserver", faxserver, REG_SZ
    SetKeyValue reg_hive, reg_key, "user", faxuser, REG_SZ
    SetKeyValue reg_hive, reg_key, "password", faxpw, REG_SZ
    SetKeyValue reg_hive, reg_key, "psviewer", Psviewer, REG_SZ
    SetKeyValue reg_hive, reg_key, "tifviewer", tifviewer, REG_SZ
    SetKeyValue reg_hive, reg_key, "debuglevel", debuglevel, REG_SZ
    SetKeyValue reg_hive, reg_key, "logfile", logfile, REG_SZ
    SetKeyValue reg_hive, reg_key, "autologon", Autologon, REG_SZ
    SetKeyValue reg_hive, reg_key, "emailaddress", emailaddress, REG_SZ
    'Call saveadrbook_info
End Sub
Public Sub saveadrbook_info()
Dim n As Long
Dim x As Collection
Dim book

    Set x = EnumKey(reg_hive, reg_key & "\Addressbooks")
    For Each book In x
        Call DeleteKey(reg_hive, reg_key & "\Addressbooks\", CStr(book))
    Next
    
    For n = 0 To adrbooks_count - 1
        CreateNewKey reg_hive, reg_key & "\Addressbooks\" & adrbooks(n).name
        SetKeyValue reg_hive, reg_key & "\Addressbooks\" & adrbooks(n).name, "atype", adrbooks(n).atype, REG_SZ
        SetKeyValue reg_hive, reg_key & "\Addressbooks\" & adrbooks(n).name, "filename", adrbooks(n).filename, REG_SZ
    Next
End Sub

Public Function getstrpart(data As String, i As Long) As String
Dim lastpos As Long
Dim pos As Long
    lastpos = 0: pos = 0
    While (InStr(lastpos + 1, data, "|") > 1) And (pos < i)
        'getstrpart = Mid(data, lastpos + 1, InStr(lastpos + 1, data, "|") - lastpos - 1)
        lastpos = InStr(lastpos + 1, data, "|")
        pos = pos + 1
    Wend
    If pos = i Then
        If InStr(lastpos + 1, data, "|") = 0 Then
            getstrpart = Mid(data, lastpos + 1, Len(data) - lastpos)
        Else
            getstrpart = Mid(data, lastpos + 1, InStr(lastpos + 1, data, "|") - lastpos - 1)
        End If
    Else
        getstrpart = ""
    End If
End Function

Public Function fileexists(ByRef name As String) As Boolean
If Dir(name) = "" Then
    fileexists = False
Else
    fileexists = True
End If
End Function

Public Function tmpfile(ext As String) As String
Dim tmppath As String
Dim tmpname As String
    Call Randomize
    tmppath = Environ("TEMP")
    Do
        tmpname = tmppath & "\w2h" & Int(Rnd * 100000) & ext
    Loop While fileexists(tmpname)
    tmpfilelist.Add tmpname
    tmpfile = tmpname
End Function

Public Sub rmtmpfiles()
Dim tmpname
    For Each tmpname In tmpfilelist
        If fileexists(CStr(tmpname)) Then Call Kill(CStr(tmpname))
    Next
End Sub
