#Author: Harald Holzer
 (harald.holzer@eunet.at)
#5.4.2000: initial release

import hfaxlib
import string

class hylafaxutil:
	_public_methods_ = ["connect","job_new","job_select","job_kill","job_delete","job_param_getall","job_param_get","job_param_set","getfolder","storefile","retrfile","deletefile","jobparam","submitjob","docmd","close","setdebuginfo"]
	_reg_progid_ = "pythonutils.hylafaxutil"
	_reg_clsid_ = "{243E9E30-0702-11D4-8088-005004EFAAEE}"
	faxserv=hfaxlib.hfax()

	def connect(self,host,user,pw):
		return self.faxserv.connect(str(host),str(user),str(pw))

	def job_new(self):
		return self.faxserv.job_new()
	def job_select(self,jobid):
		self.faxserv.job_select(jobid)
	def job_kill(self):
		self.faxserv.job_kill()
	def job_delete(self):
		self.faxserv.job_delete()
	def job_param_getall(self):
		return self.faxserv.job_param_getall()
	def job_param_get(self,pname):
		return self.faxserv.job_param_get(str(pname))
	def job_param_set(self,pname,pvalue):
		self.faxserv.job_param_set(str(pname),str(pvalue))

	def getfolder(self,folder):
		folder=str(folder)
		data=self.faxserv.getfolder(folder)
		if not data: data="None"
		return data

	def storefile(self,filename):
		return self.faxserv.storefile(str(filename))

	def retrfile(self,filename,tmpfilename):
		self.faxserv.retrfile(str(filename),str(tmpfilename))
		
	def deletefile(self,filename):
		self.faxserv.deletefile(str(filename))

	def jobparam(self,param):
		return self.faxserv.jobparam(str(param))

	def submitjob(self):
		return self.faxserv.submitjob()

	def docmd(self,cmd):
		return self.faxserv.docmd(str(cmd))

	def close(self):
		self.faxserv.close()
		
	def setdebuginfo(self,dbglevel,logfile):
		self.faxserv.setdebuginfo(dbglevel,str(logfile))

if __name__=="__main__":
	print "Registering COM Server..."
	import win32com.server.register
	win32com.server.register.UseCommandLine(hylafaxutil)
	