Attribute VB_Name = "comutils"
Option Explicit


' -----------------------------------------------------------------------------------------
'   CreateObjectSafe(comObjectName, timeout)
'
'     - purpose:
'       - creating ActiveX/COM-objects without raising runtime-exceptions
'       - polling for object-registration
'       - returning the created error or/and a native win32-error-description
'
'     - info/behaviour:
'       If "timeout" is given and the first attempt to create the object fails,
'       this tries for "timeout"-seconds to create this object in an interval of one second.
'
'     - required parameters:
'       - comObjectName: name of a com-object, e.g. "pythonutils.hylafaxutil"
'
'     - optional parameters:
'       - timeout: seconds to wait for object-registration
'       - errorDescription: "ByRef"-variable stuffed with the native win32-error-description
'
'     - returned values:
'       - (ActiveX/COM)-object, if object-creation succeeds, ...
'       - ... the "Nothing"-object, if this fails.
'
' -----------------------------------------------------------------------------------------
Public Function CreateObjectSafe(comObjectName As String, Optional timeout As Long, Optional ByRef errorDescription As String) As Object
    Dim obj As Object
    Dim timeout_counter As Long
    timeout_counter = 0
    
    ' turn off runtime-exceptions
    On Error Resume Next
        
        ' first attempt
        Set obj = CreateObject(comObjectName)
        If Err.Number <> 0 Then
            Set obj = Nothing
            
            ' poll for registration?
            If (CStr(timeout) <> "") Then
                    
                    DoEvents
                    ' following attempt(s)
                    ' loop until timeout exceeds or everything is ok
                    Do Until (timeout_counter >= timeout Or Err.Number = 0)
                        ' give some time to windows
                        DoEvents
                        ' reset error-object
                        Err.Clear
                        ' try to instantiate python-wrapper
                        Set obj = CreateObject(comObjectName)
                        ' sleep for one second
                        Sleep 1 * 1000
                        DoEvents
                    Loop
            
            End If
        End If
    
    ' store last native win32-error-description in "ByRef"-variable
    errorDescription = Err.Description
    ' return the object
    Set CreateObjectSafe = obj
    
    ' turn on runtime-exceptions
    On Error GoTo 0
    
End Function



' -----------------------------------------------------------------------------------------
'   registerComObject(comObjectName, registerCommand, bool_ask)
'
'     - required parameters:
'       - comObjectName: name of a com-object
'       - registerCommand: shell-command to register com-object
'
'     - info/behaviour:
'       This function returns "True" at the time it starts object-registration via a spawned shell.
'       This runs asynchronously and takes some time on a windows-system!
'
'     - todo:
'       - run object-registration synchronously
'       - provide better (error-)messages for object-registration
'       - don't use the shell, use the win32-api
'
'     - optional parameters:
'       - bool_ask: whether to explicitly ask & explain before registering com-object
'
'     - returned values:
'       - boolean value indicating success of operation
'
' -----------------------------------------------------------------------------------------
Public Function registerComObject(comObjectName As String, registerCommand As String, Optional bool_ask As Boolean, Optional prompt As String) As Boolean
    Dim bool_prompt_result As VbMsgBoxResult
    Dim bool_register As Boolean
    
    If (bool_ask) Then
        bool_prompt_result = MsgBox(prompt, vbYesNoCancel, "Register COM-object ""pythonutils.hylafaxutil""?")
        Select Case bool_prompt_result
            Case vbYes:
                bool_register = True
            Case vbNo:
                bool_register = False
            Case vbCancel:
                bool_register = False
        End Select
    Else
        bool_register = True
    End If
    
    If (bool_register) Then
        Shell registerCommand
        registerComObject = True
    Else
        registerComObject = False
    End If
    
End Function

