##    ------------------------------------------------------------------------
##    $Id: Logger.pm,v 1.2 2003/01/19 03:35:26 joko Exp $
##    ------------------------------------------------------------------------
##    $Log: Logger.pm,v $
##    Revision 1.2  2003/01/19 03:35:26  joko
##    + added cvs-header
##
##    ------------------------------------------------------------------------


package Torus::Logger;

use strict;
use warnings;

#require "$basepath/etc/log/Config.pm";
#BEGIN {
  use FindBin qw($Bin);
  #require "$Bin/use_libs.pl";
#}


use Log::Dispatch::Configurator::Hardwired;
use Log::Dispatch::Config;

my $bool_quiet = grep /--quiet/, @ARGV;
my $bool_debug = grep /--debug/, @ARGV;
my $bool_verbose = grep /--verbose/, @ARGV;
configureLogDispatcher( { quiet => $bool_quiet, debug => $bool_debug, verbose => $bool_verbose } );

sub configureLogDispatcher {
  my $args = shift;
  my $logHandlerMeta = Log::Dispatch::Configurator::Hardwired->new();
  # configure custom logHandler
    #$logHandlerMeta->{file_filename} = "$basepath/var/log/logfile.txt";
    $logHandlerMeta->{file_filename} = "$Bin/../var/log/logfile.txt";
    $logHandlerMeta->{screen_min_level} = 'info';
    
    if ($args->{quiet}) {
      $logHandlerMeta->{screen_min_level} = 8;
    }

    if ($args->{debug}) {
      $logHandlerMeta->{screen_min_level} = 'debug';
    }
    
    if ($args->{verbose}) {
      $logHandlerMeta->{verbose} = 1;
    }

  Log::Dispatch::Config->configure($logHandlerMeta);
}

1;
