##    ------------------------------------------------------------------------
##    $Id: Core.pm,v 1.4 2003/01/20 16:18:02 joko Exp $
##    ------------------------------------------------------------------------
##    $Log: Core.pm,v $
##    Revision 1.4  2003/01/20 16:18:02  joko
##    + connect to mapi via 'my $mapiLocator = Data::Storage::Locator->new( ... )'
##
##    Revision 1.3  2003/01/19 03:35:25  joko
##    + added cvs-header
##    ------------------------------------------------------------------------


package Torus::Core;

use strict;
use warnings;

=pod
use base qw( 
  DesignPattern::Object
  DesignPattern::Object::Logger
);
=cut

use mixin::with qw( Torus );


use Data::Dumper;

use Data::Storage;
use Data::Storage::Locator;
use Data::Transfer::Sync;


# get logger instance
my $logger = Log::Dispatch::Config->instance;

my $DEBUGLEVEL;
my $TRACELEVEL;
my $bool_started;

sub initDebugLevel {
  my $self = shift;

  $DEBUGLEVEL = $self->{config}->get("debug_level");
  $TRACELEVEL = $self->{config}->get("trace_level");

 }




sub addItem {

  my $torusObjectType = shift;
  my $mapiEntry = shift;
  my $basedn = shift;
  my $ldapEntry;

  if (!$bool_started) {
    Torus::Driver::ldap::connectStore();
  }

  $bool_started = 1;

  if ($DEBUGLEVEL > 3) {
    print STDOUT "=" x 3, "   ", __PACKAGE__, "   ", "=" x 30, "\n";
    print STDOUT "recieved torus-object (type=$torusObjectType)", "\n";
    print STDOUT "trying to write to (basedn='$basedn')", "\n";
  }

  if ($torusObjectType eq 'MapiContact') {
    $basedn = Torus::Driver::ldap::createOuSafe($basedn);
    my $entry = Torus::Driver::ldap::prepareEntry($basedn, $mapiEntry);
    if (my $result = Torus::Driver::ldap::addEntry($entry)) {
      #my $error = 0;
      #$error = 1 if $result->code >= 0;
      #Torus::Driver::ldap::traceEntry($mapiEntry, $entry, { error => $error, prefix => $result->error }) if $TRACELEVEL >= 2;
      #undef $result;
      Torus::Driver::ldap::processResult($entry->{identifier}, $result);
    }
  }

}

sub startSync {

  my $self = shift;
  my $opts = shift;

#print Dumper($self);

#print Dumper($opts);
#exit;

  my $host = $self->{config}->get("ldapserver_host");
  my $binddn = $self->{config}->get("ldapserver_binddn");
  my $pass = $self->{config}->get("ldapserver_pass");
  my $basedn = $self->{config}->get("ldapserver_basedn");
  
  my $dsn = "ldap:host=$host;binddn='$binddn';pass=$pass";
  $logger->notice(__PACKAGE__ . "->startSync: using dsn: $dsn");

  # connect to LDAP
    my $ldapLocator = Data::Storage::Locator->new(
      ldap => {
        type => "NetLDAP",
        #dsn => "ldap:host=192.168.1.56;binddn='cn=root, dc=labnet, dc=de';pass=Geheim",
        #dsn => "ldap:host=192.168.10.150;binddn='cn=root, o=netfrag.org, c=de';pass=secret",
        dsn => $dsn,
        #basedn => "o=netfrag.org, c=de",
        basedn => $basedn,
        #schema => 'BizWorks::BackendDbSchema',
        #classnames => [qw( SystemEvent LangText )],
        #classnames => [qw( SystemEvent Person Address LangText )],
        #test_availability => 1,
        #test_integrity => 1,
        #test_emptyness => 1,
        # TODO: re-enable this! (multiple-target-logging!)
        #logger => 1,
        want_transactions => 0,
        syncable => 1,
      },
    );
    my $ldapStorage = Data::Storage->new($ldapLocator);
    $ldapStorage->connect();

  # connect to MAPI
    my $mapiLocator = Data::Storage::Locator->new(
      outlook => {
        type => "MAPI",
        #dsn => "ldap:host=192.168.1.56;binddn='cn=root, dc=labnet, dc=de';pass=Geheim",
        #dsn => "ldap:host=192.168.10.150;binddn='cn=root, o=netfrag.org, c=de';pass=secret",
        #dsn => $dsn,
        #basedn => "o=netfrag.org, c=de",
        #basedn => $basedn,
        #schema => 'BizWorks::BackendDbSchema',
        #classnames => [qw( SystemEvent LangText )],
        #classnames => [qw( SystemEvent Person Address LangText )],
        #test_availability => 1,
        #test_integrity => 1,
        #test_emptyness => 1,
        # TODO: re-enable this! (multiple-target-logging!)
        #logger => 1,
        #want_transactions => 0,
        syncable => 1,
        showProfileChooser => $self->{config}->get("mapi_showProfileChooser"),
        ProfileName => $self->{config}->get("mapi_ProfileName"),
        ProfilePass => $self->{config}->get("mapi_ProfilePass"),
      },
    );
    my $mapiStorage = Data::Storage->new($mapiLocator);
    $mapiStorage->connect();
  

  # create a new synchronization object
  my $sync = Data::Transfer::Sync->new();

  # read, mungle & check the options
    $sync->prepareOptionsV2($opts);

    if (!$sync->checkOptionsV2()) {
      $logger->critical( __PACKAGE__ . "->startSync: 'Data::Transfer::Sync::checkOptions' failed.");
      return;
    }

#print Dumper($opts);


=pod
  # branch to execution path for special targets
  # detect for option 'handler' which could be a CODEref
    if ($opts->{handler} && ref $opts->{handler} eq 'CODE') {
      $logger->info( __PACKAGE__ . "->startSync: Running (special handler code - no generic sync!) on '$opts->{target}' with MODE $opts->{mode}, NODE $opts->{target_node}");
      $opts->{handler}->($self, $opts);
      return;
    }
=cut
  
  # configure synchronization-object
  $sync->configureV2(
      #L => $self->{bizWorks}->{$opts->{source}},
    source => {
      storage => {
        handle => $mapiStorage,
        writeProtected => 1,
      },
    },
    #R => $self->{bizWorks}->{$opts->{target}},
    target => {
      storage => {
        handle => $ldapStorage,
        idAuthority => 1,
        checksumAuthority => 1,
        writeProtected => 0,
      },
    },
    verbose => 1,
  );
  
  # patch options
  #$opts->{source} = "L:$opts->{source_node}" if $opts->{source_node};
  #$opts->{target} = "R:$opts->{target_node}" if $opts->{target_node};

#print Dumper($opts);

#  $sync->syncNodes($opts);
  $sync->syncNodes();

  #$mapiStorage->disconnect();

}

1;
