##    ------------------------------------------------------------------------
##    $Id: Config.pm,v 1.1 2003/01/19 07:47:41 joko Exp $
##    ------------------------------------------------------------------------
##    $Log: Config.pm,v $
##    Revision 1.1  2003/01/19 07:47:41  joko
##    - refactored from libs/loadConfig.pm
##
##    ------------------------------------------------------------------------


package Torus::Config;

use strict;
use warnings;

use mixin::with qw( Torus );

use AppConfig qw(:expand :argcount);
use Data::Dumper;

sub raiseAppConfigError {
  my $error = shift;
  my $errmsg = "error while accessing configuration-data: ";
  $errmsg .= $error if $error;
  die($errmsg);
}

sub loadConfig {
  my $self = shift;
  
  my $config = AppConfig->new({
        CASE   => 1,
              ERROR  => \&raiseAppConfigError,
        GLOBAL => {
                #DEFAULT  => "<unset>",
                DEFAULT  => "",
                ARGCOUNT => ARGCOUNT_ONE,
            },
        CREATE => 1,
    });

  #$config->define("debug_level", { ARGCOUNT => ARGCOUNT_ONE } );
  $config->define("mapi_ProfilePass", { ARGCOUNT => ARGCOUNT_NONE, DEFAULT => "" } );
  $config->define("sync_map", { ARGCOUNT => ARGCOUNT_LIST } );
  $config->define("sync_mapping", { ARGCOUNT => ARGCOUNT_HASH } );
  
  $config->define("folders_use", { ARGCOUNT => ARGCOUNT_LIST } );
  $config->define("folders_map", { ARGCOUNT => ARGCOUNT_HASH } );

#print Dumper($self);

  my $cfgfile_name = $self->{config_metadata}->{file};
  
  if (! -e $cfgfile_name) {
    print "config-file \"$cfgfile_name\"does not exist.", "\n";
    exit;
  }
  $config->file($cfgfile_name);

  $self->{config} = $config;
  
#print Dumper($self->{config});
  
  return 1;

}

1;
