#!/usr/bin/perl

##    --------------------------------------------------------------------------------
##    $Id: feed.pl,v 1.3 2003/01/20 16:29:48 joko Exp $
##    --------------------------------------------------------------------------------
##    $Log: feed.pl,v $
##    Revision 1.3  2003/01/20 16:29:48  joko
##    + new mechanism to pass configuration-metadata to Torus:
##    >     process => Torus->new(
##    >       config_metadata => { file => '../etc/syncOutlookContacts.ini' },
##    >     )
##       and stuff ....
##
##    Revision 1.2  2003/01/19 03:34:59  joko
##    + new command-line-arguments
##
##    Revision 1.1  2003/01/18 18:20:45  joko
##    + initial check-in
##
##    --------------------------------------------------------------------------------


package main;

use strict;
use warnings;

BEGIN {
  use FindBin qw($Bin);
  #require "$Bin/use_libs.pl";
}

use Tie::IxHash;


use lib qw( ../libs ../etc C:\home\amo\develop\netfrag.org\nfo\perl\libs );
use Torus::Logger;
use Torus::Core;

my $logger = Log::Dispatch::Config->instance;

#use BizWorks::Script::Feed;

#=pod
  #my $context = BizWorks::RunMe->new( app => $bizWorks, process => $bizProcess, logger => $logger );
  #my $context = BizWorks::RunMe->new();
  my $context = BizWorks::Script::Feed->new();
  $context->getoptions();
  $context->{opt}->{mapping_module} = $context->{opt}->{mapping};
  #$context->verifyoptions();
  #$context->options2actions();
  #$context->run();
  #$context->suspend();
  #$context->set( app => $bizWorks, process => $bizProcess, logger => $logger );
  my $bizWorks;
  $context->set( 
    app => $bizWorks, 
    process => Torus->new( 
      config_metadata => { file => '../etc/syncOutlookContacts.ini' }, 
    ), 
    logger => $logger,
    #config => { mappings => { 'LdapAddress' => 'xyz' } },
    
  );
#print Dumper($context);  
#print Dumper($context->{process}->{bizWorks}->{backend});
  $context->run();
  #exit;
#print Dumper($context);  
  #$context->suspend();
#=cut


#=pod
  #my $context = OEF::Component::Task->new( guid => 'ac65ea820a263948af8b4947f33f7719' );
  #my $context = OEF::Component::Task->new( guid => '767ee9ab030bb4163e67ab26ab9a8894' );
  #my $context = OEF::Component::Task->new( guid => '3a5c85995270ee8b17a8701c6f709ecf' );
  #my $context2 = OEF::Component::Task->new( guid => $context->getGuid() );
  #my $context2 = OEF::Component::Task->new( guid => '79d69fa4308d88181b882ef8d3433534' );
  
  #$context2->resume();
#print Dumper($context2);
#print Dumper($context2->{process}->{bizWorks}->{backend});
  #$context2->{process}->{bizWorks}->{backend}->connect();
  #$context2->run();
#=cut


package BizWorks::Script::Feed;

use strict;
use warnings;

use Data::Dumper;
use Getopt::Long;

#use base 'OEF::Component::Task';
use base qw( 
  DesignPattern::Object
  DesignPattern::Object::Logger
);

sub usage {
  my $self = shift;
  print "\n";
  print <<EOU;
  usage:
    feed.pl --source=<dbkey> --node=<node> --target=<dbkey> --action=<action> [--mapping=]
    
      source:  dbkey links to a configuration resource representing a storage (~= database)
      node:   the name of a node on the first level below the source storage
      target:  dbkey links to a configuration resource representing a storage
      action: <action> is issued on given dbkey as source node
        sync           FULL sync (PULL & PUSH)
        load|save      PULL or PUSH syncs
        import|export  IMPORT and EXPORT syncs
      mapping:  future use: specify name of a perl module / xml file which describes/outlines the mapping
EOU
  exit;
}

sub getoptions {
  my $self = shift;

  GetOptions(
    'source=s' => \$self->{opt}->{source},
    'source-type=s' => \$self->{opt}->{'source-type'},
    'source-node=s' => \$self->{opt}->{'source-node'},
    'target=s' => \$self->{opt}->{target},
    'target-node=s' => \$self->{opt}->{'target-node'},
    'action=s' => \$self->{opt}->{action},
    'mapping-module=s' => \$self->{opt}->{'mapping-module'},
    'prepare' => \$self->{opt}->{prepare},
    'fresh' => \$self->{opt}->{fresh},
    'help' => \&usage,
  );
}  

sub set {
  my $self = shift; 
  my $data = { @_ };
  #return bless $self, $class;
  foreach (keys %$data) {
#print $_, "\n";
    $self->{$_} = $data->{$_};
  }
}

=pod
sub run {
  my $self = shift;
  $self->{var} ||= 0;
  print __PACKAGE__, "\n";
  print "var: ", $self->{var}, "\n";
  $self->{var}++;
}
=cut

sub run {

  my $self = shift;

#print Dumper($self->{opt});

  # TODO: move this to the synchronization (startup) somehow...  (one level towards the core - just one....)
  if ($self->{opt}->{target} eq 'testdata') {
    #print Dumper($self->{opt});
    $self->{logger}->info( __PACKAGE__ . "->run: Running (special handler code - no generic sync!) on '$self->{opt}->{target}' with action $self->{opt}->{action} - no NODE");
    $self->{process}->load('Setup/Data/Test');
#print "2", "\n";
    return $self->{process}->handler();
  }

  #print Dumper($self->{opt});
  
  #$self->{process}->load('Setup');

  # TODO: 
  # - move this to Data::Transfer::Sync::checkOptions!!!
  # - remove the tail of this "if" at the bottom of this block!
  #if ($self->{app}->{config}->{databases}->{$self->{opt}->{target}}->{syncable}) {
    my $mode = '';
    my $erase = 0;
    my $import = 0;
    $mode = 'PUSH' if $self->{opt}->{action} eq 'save';
    $mode = 'PULL' if $self->{opt}->{action} eq 'load';
    if ($self->{opt}->{action} eq 'import') {
      $mode = 'PULL';
      $erase = 1;
      $import = 1;
    }
    if ($self->{opt}->{action} eq 'export') {
      $mode = 'PUSH';
      $erase = 1;
      #$import = 1;
    }


#print Dumper($self->{opt});
#exit;

    my %syncConfig;
    tie %syncConfig, 'Tie::IxHash';
    %syncConfig = (
      map => {
        moduleName => $self->{opt}->{'mapping-module'},
      },
      source => {
        dbKey => $self->{opt}->{source},
        nodeType => $self->{opt}->{'source-type'},
        nodeName => $self->{opt}->{'source-node'},
      },
      target => {
        dbKey => $self->{opt}->{target},
        nodeName => $self->{opt}->{'target-node'},
      },
      process => {
        mode => $mode,
        erase => $erase,
        import => $import,
        prepare => $self->{opt}->{prepare},
      },
      metadata => {
        config => $self->{config_metadata},
      }
    );

#print Dumper(\%syncConfig);

    $self->{process}->startSync( \%syncConfig );

=pod
  } else {
    #print "\n", "Target is not syncable", "\n";
    print "\n", "Target is not syncable", "\n";
    $self->usage();
  }
=cut

  #$self->{process}->{outlook}->disconnect();
  return;

  if ($self->{opt}->{action} eq 'load') {
    if ($self->{opt}->{target} eq 'resources') {
      fillResources();
    } elsif ($self->{opt}->{target} eq 'testdata') {
      fillTestData();
    } else {
      $self->usage();
    }

  } elsif ($self->{opt}->{action} eq 'save') {
    if ($self->{opt}->{target} eq 'resources') {
      $self->{process}->backupResources();
    } elsif ($self->{opt}->{target} eq 'testdata') {
      print "could not save $self->{opt}->{resource}, it's stored inside a perl module", "\n";
    } else {
      $self->usage();
    }

  } elsif ($self->{opt}->{action} eq 'import') {
    if (!$self->{opt}->{node}) { print "option \"--action=import\" requires option \"--node\"", "\n"; $self->usage(); }
    
  } else {
    $self->usage();
  }

  $self->{process}->{storage}->disconnect();

}

1;


package BizWorks::RunMe;

use strict;
use warnings;

#use base 'OEF::Component::Task';
use base qw( 
  DesignPattern::Object
  DesignPattern::Object::Logger
);

use Getopt::Long;
#use BizWorks::Boot qw( $bizWorks $bizProcess );
use Data::Dumper;
use Getopt::Long;
use Carp;




sub getoptions {
  my $self = shift;

  $self->{'opt'}->{'source'} = 'backend';
  $self->{'opt'}->{'target'} = 'testdata';
  $self->{'opt'}->{'action'} = 'load';
  
  # TODO: use some core function/method (e.g. 'init_hash($hashref, $value, $force = 0)')
  $self->{opt}->{source} ||= '';
  $self->{opt}->{node} ||= '';
  $self->{opt}->{target} ||= '';
  $self->{opt}->{action} ||= '';
  $self->{opt}->{mapping} ||= '';
  $self->{opt}->{prepare} ||= '';
  $self->{opt}->{fresh} ||= '';

}


sub run {

  my $self = shift;

#print Dumper($self->{opt});

  # TODO: move this to the synchroninzation (startup) somehow...  (one level towards the core - just one....)
  if ($self->{opt}->{target} eq 'testdata') {
    #print Dumper($self->{opt});
    $self->{logger}->info( __PACKAGE__ . "->run: Running (special handler code - no generic sync!) on '$self->{opt}->{target}' with action $self->{opt}->{action} - no NODE");
    $self->{process}->load('Setup/Data/Test');
#print "2", "\n";
    return $self->{process}->handler();
  }

  #print Dumper($self->{opt});
  
  #$self->{process}->load('Setup');

  # TODO: 
  # - move this to Data::Transfer::Sync::checkOptions!!!
  # - remove the tail of this "if" at the bottom of this block!
  #if ($self->{app}->{config}->{databases}->{$self->{opt}->{target}}->{syncable}) {
    my $mode = '';
    my $erase = 0;
    my $import = 0;
    $mode = 'PUSH' if $self->{opt}->{action} eq 'save';
    $mode = 'PULL' if $self->{opt}->{action} eq 'load';
    if ($self->{opt}->{action} eq 'import') {
      $mode = 'PULL';
      $erase = 1;
      $import = 1;
    }
    if ($self->{opt}->{action} eq 'export') {
      $mode = 'PUSH';
      $erase = 1;
      #$import = 1;
    }
    $self->{process}->startSync({
      source => $self->{opt}->{source},
      source_node => $self->{opt}->{node},
      target => $self->{opt}->{target},
      mode => $mode,
      erase => $erase,
      import => $import,
      mapping => $self->{opt}->{mapping},
      prepare => $self->{opt}->{prepare},
    });

=pod
  } else {
    #print "\n", "Target is not syncable", "\n";
    print "\n", "Target is not syncable", "\n";
    $self->usage();
  }
=cut

  $self->{process}->{storage}->disconnect();
  return;

  if ($self->{opt}->{action} eq 'load') {
    if ($self->{opt}->{target} eq 'resources') {
      fillResources();
    } elsif ($self->{opt}->{target} eq 'testdata') {
      fillTestData();
    } else {
      $self->usage();
    }

  } elsif ($self->{opt}->{action} eq 'save') {
    if ($self->{opt}->{target} eq 'resources') {
      $self->{process}->backupResources();
    } elsif ($self->{opt}->{target} eq 'testdata') {
      print "could not save $self->{opt}->{resource}, it's stored inside a perl module", "\n";
    } else {
      $self->usage();
    }

  } elsif ($self->{opt}->{action} eq 'import') {
    if (!$self->{opt}->{node}) { print "option \"--action=import\" requires option \"--node\"", "\n"; $self->usage(); }
    
  } else {
    $self->usage();
  }

  $self->{process}->{storage}->disconnect();

}


1;
