#
# Add error reporting to Win32::OLE
#

package Win32::OLE::Strict;
use Carp;
use Win32::OLE;
use Win32::OLE::NLS qw(:LOCALE :DATE);

use strict qw(vars);
our @ISA = qw( Win32::OLE Win32::OLE::NLS );
use vars qw($AUTOLOAD @ISA);

sub AUTOLOAD {
  my $obj = shift;
  $AUTOLOAD =~ s/^.*:://;
  my $meth = $AUTOLOAD;
  $AUTOLOAD = "SUPER::" . $AUTOLOAD;
  my $retval = $obj->$AUTOLOAD(@_);
  unless (defined($retval) || $AUTOLOAD eq 'DESTROY') {
      my $err = Win32::OLE::LastError();
      croak(sprintf("$meth returned OLE error 0x%08x",$err))
        if $err;
  }
  return $retval;
}

1;
