package Torus::Reflection::schema;

use strict;
use warnings;

# config

my $ldapAttributeIdPrefix="1.3.6.1.4.1.13040.1.2.66";
my $ldapAttributetypeSUP="name";
my %ldapObjectClassArguments = (
  "objectclassid" => $ldapAttributeIdPrefix . ".1001",
  "NAME" => "'msMapi'",
  "DESC" => "'msMapi Schema'",
  "SUP" => "person",
);


sub genSchema {

    my $sourceFileName=shift;
    open (FH,"<".$sourceFileName) or die "could not open \"$sourceFileName\" for reading, exit!\n";
  # main
  
  my %buffer;
  my $counter = 0;
  my $counter_attributesUsed = 0;
  while (my $line = <FH>) {
    $counter++;
    chomp ($line);
    my @entry=split(";",$line);
    my $mapiAttributeName=$entry[0];
    my $ldapAttributeName=$entry[1];
    my $ldapObjectClassName=$entry[2];
    
    
    #print "line: $line\n";
    
    # go on?
      # no ldap-attribute?
      next if (!$ldapAttributeName);
      # no ldap-objectclass?
      next if (!$ldapObjectClassName);
      # just certain objectclasses?
      next if ($ldapObjectClassName ne "msMapi");

    #print "line: $line\n";

    # preparing fill
    my $prefix_ldapAttr = '		';
    $prefix_ldapAttr = '		$ ' if ($counter_attributesUsed);

    # fill buffers
    $counter_attributesUsed++;
    $buffer{attributes} .= "attributetype ( $ldapAttributeIdPrefix.$counter_attributesUsed NAME '$ldapAttributeName' SUP $ldapAttributetypeSUP )\n";
    $buffer{objectClassMay} .= $prefix_ldapAttr . $ldapAttributeName . "\n";

   }

  close (FH);
  
  return if !$counter;
  
  my $masterbuffer;
  
  $masterbuffer .= $buffer{attributes} . "\n";
  
  $masterbuffer .= "objectclass (  $ldapObjectClassArguments{objectclassid}
  	NAME $ldapObjectClassArguments{NAME}
  	DESC $ldapObjectClassArguments{DESC}
  	SUP $ldapObjectClassArguments{SUP}
  	MAY ( \n";
  $masterbuffer .= $buffer{objectClassMay} if ($buffer{objectClassMay});
  $masterbuffer .= "	) )" . "\n";
    return $masterbuffer;

}

1;
