#use Unicode::MapUTF8 qw(to_utf8 from_utf8 utf8_supported_charset);
use Data::Transform::Encode qw( var2utf8 var_utf2iso );
use Data::Dumper;

my $hr = "=" x 80 . "\n";

# debugging?
my $DEBUGLEVEL = $config->get("debug_level");
my $TRACELEVEL = $config->get("trace_level");

my $dnCache;
my $criticalCache;
my $msgCache;


# ==================================================
#    configure here
# ==================================================
#my $binddn = 'cn=root, dc=labnet, dc=de';
my $binddn = 'cn=admin, o=netfrag.org, c=de';
#my $binddn = 'cn=admin';

# V1: hardcoded target ou
#my $basedn = 'ou=Adressen, dc=labnet, dc=de';

# V2: now passed-in to "addEntry"

my $cfg_objectclasses = [ qw( 
		Person
		inetOrgPerson 
		organizationalPerson
		pilotPerson
		groupOfNames
		) ];
#		msMapi
#		outlookPerson

#
# other object classes:
# outlookPerson
# ==================================================


my $ldap;
my $map;


sub getEntry {

  die("getEntry!");
  
  my $basedn = '';
  
  connectStore();

        my $mesg = $ldap->search (  # perform a search
                               base   => $basedn,
                               filter => "(&(sn=*))"
                              );

        $mesg->code && die $mesg->error;

  foreach my $entry ($mesg->all_entries) { 
    $entry->dump;
    print "\n";
  }

  disconnectStore();

}

sub _example {
   print "abcdef", "\n";
        my $result = $ldap->add ( 
		     'cn = Barbara Jensen, o=University of Michigan, c=us',
                      attr => [ 'cn'   => [ 'Barbara Jensen', 'Barbs Jensen' ],
                                'sn'   => 'Jensen',
                                'mail' => 'b.jensen@umich.edu',
                                'objectclass' => ['top', 'person',
                                                  'organizationalPerson',
                                                  'inetOrgPerson' ],
                              ]
                    );

}

sub changeEntry {

  my $dn = shift;
  my $

            $ldap->modify( $dn,
              changes => [
                add     => [ sn => 'Barr' ],              # Add sn=Barr
                delete  => [ faxNumber => []],            # Delete all fax numbers
                delete  => [ telephoneNumber => ['911']], # delete phone number 911
                replace => [ email => 'gbarr@pobox.com']  # change email address
              ]
            );

}


sub prepareEntry {

  my $basedn = shift;
  my $mapiEntry = shift;
  
  my $ldapEntry;

  my $mapfile = '../etc/' . $config->get("fields_mapfile");
  readFieldMapping($mapfile);

  # dump mapi-entry - don't do that! this is large!
  #print Dumper($mapiEntry);
  #exit;

  # utf8-conversion of unmapped mapi-entry - don't do that! this is large!
  #var2utf8($mapiEntry);

  # map entry
  foreach my $mapiKey (keys %{$mapiEntry}) {
    my $ldapKey = $map->{ldap}{$mapiKey};
    my $ldapValue = $mapiEntry->{$mapiKey};
    next if (!$ldapKey);

    # utf8-conversion
    #$ldapKey   = toUTF8($ldapKey);
    #$ldapValue = toUTF8($ldapValue);

    $ldapEntry->{$ldapKey} = $ldapValue;
  }
  
  # utf8-conversion of mapped ldap-entry
  var2utf8($ldapEntry);

  # dump ldap-entry - this is okay
  #print "ldap-entry before adding:", "\n";
  #print STDOUT Dumper($ldapEntry);
    
  # build dn here
  my $entryIdentifier = buildSnCn( {
    #sn => $sn,
    #givenname => $ldapEntry->{givenname},
    LastName => $mapiEntry->{LastName},
    FirstName => $mapiEntry->{FirstName},
    FileAs => $mapiEntry->{FileAs},
    CompanyName => $mapiEntry->{CompanyName},
    EntryID => $mapiEntry->{EntryID},
  } );
  
  my $sn = $entryIdentifier->{sn};
  my $cn = $entryIdentifier->{cn};
  
  if (!$cn) {
    rememberCriticalEntry("mapi", $mapiEntry->{EntryID});
    logError('App', "Couldn't build required ldap-attribute \"cn\". LastName/FirstName/FileAs/CompanyName were empty.");
    return;
  }
  
  # remember all already used "cn"s
  addDnCache($cn);
  
  my $must = {
    cn => $cn,
    sn => $sn,
    member => $ldapEntry->{member},
    objectClass => $cfg_objectclasses,
  };
  # utf8-conversion of must-have fields
  var2utf8($must);

  my $dn = buildDn( { basedn => $basedn, cn => $must->{cn} } );
  rememberMessage($dn, $entryIdentifier->{info});

  return { identifier => $dn, must => $must, may => $ldapEntry };
  
}

sub addEntry {
    
  my $entry_raw = shift;
  
  #print Dumper($entry_raw);
  #return;
  
  my $identifier = $entry_raw->{identifier};
  my $must = $entry_raw->{must};
  my $may = $entry_raw->{may};
  
  my $dn = $identifier;
    
  # delete entry (dn) first
  if (existsEntry('cn', $dn)) {
    print "entry exists (dn='$dn') deleting", "\n" if $DEBUGLEVEL > 3;
    $ldap->delete($dn);
  }

  #print "dn: $dn", "\n";
  #exit;

  my $entry = Net::LDAP::Entry->new;
  $entry->dn($dn);
  
  $entry->add(
    cn => $must->{cn},
    sn => $must->{sn},
    member => $must->{dn},
    objectClass => $must->{objectClass},
   );
    #sn => 'Nachname',
    #cn => 'Vorname Nachname',
   my $result1 = $entry->add(%{$may});

#print Dumper($result1), "\n";
#print Dumper($entry);

  my $result = $entry->update($ldap);
  #print Dumper($ldap->sync());

#print "result:", "\n";
#print Dumper($result);
#exit;

  #print "trace-level > 0: ", ($config->get("trace_level") > 0), "\n";
  #exit;
  
  #traceEntry($mapiEntry, $entry, { error => $error, prefix => $result->error }) if $TRACELEVEL >= 2;
  #return 1 if !$error;

  return $result;

}

sub logError {
  my $type = shift;
  my $message = shift;
  my $options = shift;
  if ($DEBUGLEVEL >= 1) {
    print STDOUT "\n" if $DEBUGLEVEL <= 1;
    print STDOUT "ERROR ($type): $message", "\n" ;
    my $buffer = '';
    foreach (keys %$options) {
      $buffer .= "  $_: $options->{$_}\n" if $options->{$_};
    }
    #print STDOUT Dumper($options), "\n";
    print STDOUT $buffer;
  }
}

sub logInfo {
  my $type = shift;
  my $message = shift;
  if ($DEBUGLEVEL >= 1) {
    print STDOUT "\n" if $DEBUGLEVEL <= 1;
    print STDOUT "INFO ($type): $message", "\n" ;
  }
}

sub traceEntry {
  my $entry_source = shift;
  my $entry_target = shift;
  my $options = shift;
  
  my $logfile = '../log/transfer.log';
  if ($options->{error}) {
    $logfile = '../log/errors.log';
  }
  
  my $dump_source = Dumper($entry_source);
  
  #my $dump_target = Dumper($entry_target);
  my $dump_target = "\n";
  foreach my $attr ($entry_target->attributes) {
    my $subentry = $attr . ": ";
    my @value = $entry_target->get_value($attr);
    if ($#value > 0) {
      #push @value, "\n   ";
      $subentry .= "\n   ";
    }
    $subentry .= join("\n   ", @value);
    $dump_target .= $subentry . "\n";
  }
  
  my $dump = <<EOD;
  $hr
  MAPI-Object:
  $dump_source
  $hr
  Net::LDAP::Entry:
  $dump_target
  $hr
EOD

  $dump = $hr . $options->{prefix} . $dump if $options->{prefix};

  a2f($logfile, $dump);
  
}

sub toUTF8 {
  my $string = shift;
  #return to_utf8( -string => $string, -charset => 'ISO-8859-1');
  print "before: $string", "\n";
  var2utf8(\$string);
  print "after: $string", "\n";
  return $string;
}

sub readFieldMapping {
  my $mapfile = shift;
  if (! -e $mapfile) {
    print "mapfile \"$mapfile\" does not exist.", "\n";
    exit;
  }
  open(FH, '<', $mapfile);
    while(<FH>) {
      s/\r\n/\n/g;
      chomp();
      next if (m/^#/);
      my @entry = split(';', $_);
      my $key = $entry[0];
      my $key_ldap = $entry[1];
      $key_ldap ||= '';
      $map->{mapi}{$key} = 1;
      $map->{ldap}{$key} = $key_ldap;
    }
  close(FH);
}

sub checkOu {
  my $basedn = shift;
  my $ou = shift;

  my $mesg = $ldap->search (                # perform a search
                         base   => $basedn,
                         filter => "(&(ou=$ou))"
                        );
  
  #print "search-result-code: ", $mesg->code, "\n";
  #print "search-result-error: ", $mesg->error, "\n";
  
  #return;
  #print Dumper($mesg);
  #exit;
  
  #$mesg->code && die $mesg->error;

  return 1 if exists $mesg->{entries};

}


sub buildSnCn {
  my $parts = shift;
  
  my $logmsg;
  
  my $cn;
  
  if ($parts->{LastName}) {
    # use pure "sn" first!
    $cn = $parts->{LastName} ;
  
    # add "givenname" to "cn" if exists
    $cn = $parts->{FirstName} . ' ' . $cn if $parts->{FirstName};
  }

  # check if "cn" is already filled, else provide some fallback-mechanism(s) here
    # use "FileAs"
    if (!$cn && $parts->{FileAs}) {
      $cn = $parts->{FileAs};
      $logmsg = "using \"FileAs\" for \"cn\": $cn";
    }
    # use "FirstName"
    if (!$cn && $parts->{FirstName}) {
      $cn = $parts->{FirstName};
      $logmsg = "using \"FirstName\" for \"cn\": $cn";
    }
    # use "CompanyName"
    if (!$cn && $parts->{CompanyName}) {
      $cn = $parts->{CompanyName};
      $logmsg = "using \"CompanyName\" for \"cn\": $cn";
    }

  # handle "must-have"-field "sn"
    my $sn = $parts->{LastName};

  # additional (last) rule: use unique identifier (EntryID) as "cn" if it's still empty
    #$cn = 'ident - ' . $parts->{EntryID} if !$cn;
    if (!$cn) {
      $cn = $parts->{EntryID};
      $logmsg = "\"cn\" was empty, using EntryID.\n  - cn: $cn";
    }

  # fallback to "cn" if "sn" is empty
    $sn = $cn if !$sn;
  
  # check for collisions in "cn"s
    if (dnAlreadyUsed($cn)) {
      #logError('App', "Couldn't use cn='$cn' - already exists!");
      #return;
      $cn .= '-' . $parts->{EntryID};
      $logmsg .= "\n  - modified \"cn\" to prevent name-collision.\n  - cn: $cn";
    }

    #$msgCache->{} = $logmsg;
    logInfo('App::buildCn', $logmsg) if $logmsg;

    return { sn => $sn, cn => $cn, info => $logmsg };
  
}

sub buildDn {
  my $parts = shift;
  
  # build "dn"
  my $dn = join(', ', "cn=" . $parts->{cn}, $parts->{basedn});
  
  # patch dn (remove forbidden characters)
  $dn =~ s/\+/&/g;
  
  return $dn;
}

sub clearDnCache {
  $dnCache = {};
  $msgCache = {};
}

sub addDnCache {
  my $key = shift;
  $dnCache->{$key}++;
}

sub dnAlreadyUsed {
  my $key = shift;
  return exists $dnCache->{$key};
}

sub rememberCriticalEntry {
  my $type = shift;
  my $identifier = shift;
  push @$criticalCache, { type => $type, identifier => $identifier };
}

sub showCriticalEntries {
  return if !$criticalCache;
  my @criticals = @$criticalCache;
  if ($#criticals != -1) {
    print "=" x 60, "\n";
    print "Some errors occoured while processing data, show details? (y|n) ";
    my $answer = <STDIN>;
    print "\n";
    if ($answer =~ m/^y/i) {
      foreach (@criticals) {
        #print join("\n", @criticals);
        #print Dumper($_);
        print $_->{type}, ": ", $_->{identifier}, "\n";
        print "  ", $msgCache->{$_->{identifier}}, "\n";
        delete $msgCache->{$_->{identifier}};
      }
    }
  }
}

sub showGoodEntries {
  print "=" x 60, "\n";
  print "Show good entries? (y|n) ";
  my $answer = <STDIN>;
  print "\n";
  if ($answer =~ m/^y/i) {
    foreach (keys %$msgCache) {
      print $_, ": ", $msgCache->{$_}, "\n" if $msgCache->{$_};
    }
  }
}

sub processResult {

  my $dn = shift;
  my $result = shift;

#print "dn: $dn", "\n";
#print Dumper($result);

  my $error = 0;
  my $error_code;
  my $error_message;
  if ($result) {
    $error_code = $result->code;
    $error_message = $result->error;
  } else {
    $error_code = 'n/a';
    $error_message = "NO RESULT FROM LDAP-SERVER";
  }
  
  if ($error_code) {
    rememberCriticalEntry("ldap", $dn);
    my $errmesg = "(error=$error_message, code=$error_code)";
    rememberMessage($dn, $errmesg);
    logError("LDAP", $errmesg, { dn => $dn } );
    $error = 1;
  } else {
    print "SUCCESS for (dn='$dn')", "\n" if $DEBUGLEVEL > 1;
  }
  
  undef $result;
}

sub rememberMessage {
  my $ident = shift;
  my $mesg = shift;
  $msgCache->{$ident} = $mesg;
}

1;
