package Torus::Core;

require Exporter;
our @ISA = qw(Exporter);
our @EXPORT = qw( addEntry toUTF8 );

use strict;
use warnings;

use Net::LDAP;
use Net::LDAP::Entry;
use Unicode::MapUTF8 qw(to_utf8 from_utf8 utf8_supported_charset);
use Data::Dumper;

# ==================================================
#    configure here
# ==================================================
my $binddn = 'cn=root, dc=labnet, dc=de';
my $basedn = 'ou=Adressen, dc=labnet, dc=de';
my $cfg_objectclasses = [ qw( 
		Person
		inetOrgPerson 
		organizationalPerson
		pilotPerson
		groupOfNames
		outlookPerson
		) ];
#
# other object classes:
# outlookPerson
# ==================================================


my $ldap;
my $map;

sub connectStore {

  $ldap = Net::LDAP->new('localhost', onerror => 'warn');
  $ldap->bind ( 
    $binddn,
    password => 'Geheim'
  ) or die "$@";

}

sub disconnectStore {
  $ldap->unbind;   # take down session
}

sub getEntry {

  connectStore();

        my $mesg = $ldap->search (  # perform a search
                               base   => $basedn,
                               filter => "(&(sn=*))"
                              );

        $mesg->code && die $mesg->error;

  foreach my $entry ($mesg->all_entries) { 
    $entry->dump;
    print "\n";
  }

  disconnectStore();

}

sub abcdef {
   print "abcdef", "\n";
        my $result = $ldap->add ( 
		     'cn = Barbara Jensen, o=University of Michigan, c=us',
                      attr => [ 'cn'   => [ 'Barbara Jensen', 'Barbs Jensen' ],
                                'sn'   => 'Jensen',
                                'mail' => 'b.jensen@umich.edu',
                                'objectclass' => ['top', 'person',
                                                  'organizationalPerson',
                                                  'inetOrgPerson' ],
                              ]
                    );

}

sub changeEntry {

  my $dn = shift;
  my $

            $ldap->modify( $dn,
              changes => [
                add     => [ sn => 'Barr' ],              # Add sn=Barr
                delete  => [ faxNumber => []],            # Delete all fax numbers
                delete  => [ telephoneNumber => ['911']], # delete phone number 911
                replace => [ email => 'gbarr@pobox.com']  # change email address
              ]
            );

}


sub addEntry {

  my $mapiEntry = shift;
  my $ldapEntry;

  # map entry
  foreach my $mapiKey (keys %{$mapiEntry}) {
    my $ldapKey = $map->{ldap}{$mapiKey};
    next if (!$ldapKey);
    $ldapEntry->{$ldapKey} = $mapiEntry->{$mapiKey};
  }
  print "ldap-entry before adding:", "\n";
  print STDOUT Dumper($ldapEntry);

#  connectStore();

         my $entry = Net::LDAP::Entry->new;

	 my $sn = $ldapEntry->{sn};

#         if (!$sn) {
#	   print "no attribute \"sn\" set!", "\n";
#	   return;
#	 }

         if (!$ldapEntry->{sn}) {
	   print STDOUT "could not build \"dn/cn\", no attribute \"sn\" set, will not attempt to import!", "\n";
	   return;
	 }

	 # build dn here
	 my $dn_sn = $sn;
         if ($ldapEntry->{givenname}) { $dn_sn = $ldapEntry->{givenname} . ' ' . $dn_sn; }
	 my $dn = 'cn=' . $dn_sn  . ', ' . $basedn;
	 # patch dn (remove forbidden characters)
	 $dn =~ s/\+/&/g;


	 # delete entry (dn) first
	 $ldap->delete($dn);

	 $entry->dn($dn);
         $entry->add(
#           sn => 'Nachname',
#           cn => 'Vorname Nachname',
           cn => $dn_sn,
	   member => $dn,
           objectClass => $cfg_objectclasses,
         );
	 $entry->add(%{$ldapEntry});

         my $result = $entry->update($ldap);
	 my $hr = "=" x 80;

         if ($result->code) {
	   print STDOUT $hr, "   TRANSFER-ERROR", "\n";
           print STDOUT "-" x 60, " MAPI-Object", "\n";
           print STDOUT Dumper(%{$ldapEntry});
	   print "\n";
           print STDOUT "-" x 60, " Net::LDAP::Entry", "\n";
	   print STDOUT $entry->dump;
           print STDOUT "\n";
         }


#  disconnectStore();

}

sub toUTF8 {
  my $string = shift;
  return to_utf8( -string => $string, -charset => 'ISO-8859-1');
}

sub readFieldMapping {
  my $mapfile = shift;
  if (! -e $mapfile) {
    print "mapfile \"$mapfile\" does not exist.", "\n";
    exit;
  }
  open(FH, '<', $mapfile);
    while(<FH>) {
      s/\r\n/\n/g;
      chomp();
      next if (m/^#/);
      my @entry = split(';', $_);
      my $key = $entry[0];
      my $key_ldap = $entry[1];
      $key_ldap ||= '';
      $map->{mapi}{$key} = 1;
      $map->{ldap}{$key} = $key_ldap;
    }
  close(FH);
}

1;
