##    ------------------------------------------------------------------------
##    $Id: API.pm,v 1.3 2003/01/19 03:35:25 joko Exp $
##    ------------------------------------------------------------------------
##    $Log: API.pm,v $
##    Revision 1.3  2003/01/19 03:35:25  joko
##    + added cvs-header
##
##    ------------------------------------------------------------------------


package Torus::API;

use strict;
use warnings;

# load configuration-data from ini-file
BEGIN {
  use loadConfig;
}

use Torus::Core;
use Data::Dumper;


sub sendContact {
  my $modulename = shift;
  my $sourceFolderName = shift;
  my $data = shift;

#  print Dumper($data);

  my $data_transfer;

  foreach my $key (sort keys %{$data}) {
    my $value = $data->{$key};
    #print $key, ": ", $value, "\n";
    next if (!$value);

    $data_transfer->{$key} = $value;
  }


# V2: 2003-01-06 - dynamic target container configuration
  my $folderMapping = $config->get("folders_map");
  my $container;
  # 1. use default
  $container = $folderMapping->{_default};
  # 2. try to determine target-container by mapping currently "use"d folder against ini-configuration
  $container = $folderMapping->{$sourceFolderName} if $folderMapping->{$sourceFolderName};
#  my $basedn = "ou=$container, dc=labnet, dc=de";
  my $basedn = "ou=$container, o=netfrag.org, c=de";
  

  return Torus::Core::addItem('MapiContact', $data_transfer, $basedn);

}

1;
