##    ------------------------------------------------------------------------
##    $Id: Outlook.pm,v 1.3 2003/01/20 16:25:41 joko Exp $
##    ------------------------------------------------------------------------
##    $Log: Outlook.pm,v $
##    Revision 1.3  2003/01/20 16:25:41  joko
##    - removed old code (object-constructor)
##    + introduced new property for mapping-declaration: "autocreateFolders": should ldap-ou's be created automagically?
##    + modified source-ident: it's the "EntryID" by now - FIXME: use a 'rule-built-dn' here as source-identifier!
##
##    Revision 1.2  2003/01/19 03:32:39  joko
##    + new proposal for passing metadata-information to 'Data::Transfer::Sync'
##
##    ------------------------------------------------------------------------


package Torus::Map::Outlook;

use strict;
use warnings;

use base qw( DesignPattern::Object );

use Data::Transform::Map;
use Data::Dumper;

=pod
sub Folder {
  my $self = shift;
  my $baseMap = shift;
  print Dumper($baseMap);
  exit;
  
  my $sourceFolder = $baseMap->{source};
  my $targetFolder = $sourceFolder;
  print "Mapping MAPI-Folder \"$sourceFolder\" to LDAP-Folder \"$targetFolder\".", "\n";
}
=cut


sub ContactItem {
  return {

    metadata => {
      version => 0.2,
      syncMethod => 'checksum',
    },

    # metadata on node-level
      source => {
        #nodeType => 'ContactItem',
        ident => 'property:EntryID',
        exclude => [qw( cs )],
      },
      target => {
        #address => 'code:Folder',
        #ident => 'property:rid',
        ident => 'code:dn',
        autocreateFolders => 1,
      },

    # metadata on field-level
      fieldmap => Data::Transform::Map->new(
        lookup => 'local',     # local|dsn(csv|xml|ldap)
        rules => [
          { source => 'ckey', target => 'rkey' },
          { source => 'cname', target => 'rval' },
        ],
      ),
  };
}

1;
