#!/usr/bin/perl

# ==================================
#  startup
# ==================================

use strict;
use warnings;

# load configuration-data from ini-file
BEGIN {
  use lib '../libs';
  use loadConfig;
}

use Torus::API;

=pod
# autodispatch to Torus::API
use SOAP::Lite +autodispatch =>
  proxy => "http://" . $config->get("soapservice_host") . ":" . $config->get("soapservice_port"),
;
=cut


# for accessing MAPI via Win32::OLE ("Outlook.Application")
use Torus::Driver::mapi;

# dumping data or arbitrary objects
use Data::Dumper;

use Getopt::Long;


our $VERSION = '0.08';

# ==================================
#  main
# ==================================

my $DEBUGLEVEL = $config->get("debug_level");

my $options;
GetOptions(
  'mapidump' => \$options->{mapidump},
);

my $hr = "-" x 60 . "\n";

#Torus::Driver::mapi::readFieldMapping($config->get('file_mapping'));
Torus::Driver::mapi::start();

  # V1 - get the default "Contact"-folder
  #my $Contacts = Torus::Driver::mapi::getContactFolder();
  # V2 - get an arbitrary specified folder
  #my $Contacts = Torus::Driver::mapi::getContactFolder("test");
  # V3 - work with multiple folders

  my $foldernames = $config->get("folders_use");
  foreach my $foldername (@$foldernames) {
    #Torus::Driver::ldap::clearDnCache();
    print $hr, "   trying to access MAPI-Folder \"", $foldername, "\"", "\n", $hr;
    if (my $Contacts = Torus::Driver::mapi::getContactFolder($foldername)) {
      print "   - syncing MAPI-Folder \"", $Contacts->name, "\"", "\n";
      Torus::Driver::mapi::readMapiFolder($Contacts, $foldername, \&cb_getContact, $options);
      print "\n";
    } else {
      print "   - could not access MAPI-Folder \"", $foldername, "\"", "\n";
    }
  }

Torus::Driver::mapi::stop();

Torus::Driver::ldap::showCriticalEntries();
Torus::Driver::ldap::showGoodEntries();


# callback-function, recieves each Contact-Item data (attributes) as hash
sub cb_getContact {
  # reference to hash with object-attributes
  my $sourceFolderName = shift;
  my $contact = shift;
  Torus::API->sendContact($sourceFolderName, $contact);
  print "." if $DEBUGLEVEL <= 1;
}

print "\n" if $DEBUGLEVEL <= 1;
print "ready.", "\n";
